package gov.va.med.mhv.usermgmt.service.impl;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.integration.phr.transfer.PatientExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.PatientIdentifier;
import gov.va.med.mhv.integration.phr.transfer.RefreshDataParameters;
import gov.va.med.mhv.service.MHVAbstractService;
import gov.va.med.mhv.usermgmt.bizobj.ExtractControlBO;
import gov.va.med.mhv.usermgmt.bizobj.MhvDownloadReportAssembler;
import gov.va.med.mhv.usermgmt.bizobj.MhvDownloadReportBO;
import gov.va.med.mhv.usermgmt.enumeration.MhvDownloadReportStatus;
import gov.va.med.mhv.usermgmt.integration.adapter.PatientExtractServiceAdapter;
import gov.va.med.mhv.usermgmt.integration.adapter.PhrManagerAdapter;
import gov.va.med.mhv.usermgmt.integration.service.delegate.IntegrationServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.integration.service.delegate.PatientDataServiceDelegate;
import gov.va.med.mhv.usermgmt.integration.service.util.PhrInterfaceUtils;
import gov.va.med.mhv.usermgmt.service.AccessControlCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.BBPHRRefreshStatusServiceResponse;
import gov.va.med.mhv.usermgmt.service.DownloadYourReportService;
import gov.va.med.mhv.usermgmt.service.FacilityExtractStatusCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.MhvDownloadReportCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.MhvDownloadReportServiceResponse;
import gov.va.med.mhv.usermgmt.service.adapter.PhrConfigProperties;
import gov.va.med.mhv.usermgmt.service.delegate.AccessControlServiceDelegate;
import gov.va.med.mhv.usermgmt.service.delegate.ServiceDelegateFactory;
import gov.va.med.mhv.usermgmt.transfer.BBPHRRefreshStatus;
import gov.va.med.mhv.usermgmt.transfer.FacilityExtractStatus;
import gov.va.med.mhv.usermgmt.transfer.MhvDownloadReport;
import gov.va.med.mhv.usermgmt.transfer.Patient;
import gov.va.med.mhv.usermgmt.transfer.TransferObjectFactory;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.util.AccessControlUtils;
import gov.va.med.mhv.usermgmt.util.AccessDomainUtils;
import gov.va.med.mhv.usermgmt.util.AccessPermissionUtils;
import gov.va.med.mhv.usermgmt.util.ExtractEnablementStatusUtils;


import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;


import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.BooleanServiceResponse;
import org.tigris.atlas.service.VoidServiceResponse;

/**
 * Service implementation class for the DownloadYourReport service
 * @see gov.va.med.mhv.usermgmt.service.DownloadYourReportService
 */
public class DownloadYourReportServiceImpl extends MHVAbstractService implements DownloadYourReportService {

	private static Log LOG = LogFactory.getLog(DownloadYourReportServiceImpl.class);
    private PatientExtractServiceAdapter adapter =  new PatientExtractServiceAdapter();

	/**
	 * Execute the GetDownloadedReport service
	 * @see gov.va.med.mhv.usermgmt.service.DownloadYourReportService#GetDownloadedReport()
	 */
	public MhvDownloadReportCollectionServiceResponse getDownloadedReport(Long userProfileId) {
		MhvDownloadReportCollectionServiceResponse response = new MhvDownloadReportCollectionServiceResponse();

		Collection reports = null;
		try {
			reports = MhvDownloadReportAssembler.getMhvDownloadReportCollection(MhvDownloadReportBO.getDownloadedReportByProfileId(userProfileId));
			// Only Getting the latest Reports Now..
			if(reports.size() > 0) {
				MhvDownloadReport latestReport = getLatestReport(reports);
				LOG.info("Latest Report is in status: " + latestReport.getStatus().getName());
				if (MhvDownloadReportStatus.ERROR.equals(latestReport.getStatus().getName())) {
					LOG.error("USERID " +userProfileId +" is having his Latest Report in ERROR status. Download Report Id= " + latestReport.getDownloadReportId());
					// It will override the default delegate Impl generic error message..
					addError(response,"downloadData.report.general");
				}
				response.addMhvDownloadReport(latestReport);
			}
			else {
				LOG.error("NO RECORD exists for the user: " +userProfileId);
				addError(response, "downloadData.report.general");
				response.addMhvDownloadReports(reports);
			}
		} catch (Exception ex) {
			response.addMhvDownloadReports(reports);
			addError(response,"downloadData.report.general");
			logMessages(response);
		}
		return response;
	}

	private MhvDownloadReport getLatestReport(Collection reports) {
		MhvDownloadReport latestObj= null;
		if(reports.size() > 0) {
			Iterator it = reports.iterator();
			List theList = new ArrayList(reports);
			latestObj = (MhvDownloadReport) theList.get(0);
			while(it.hasNext()) {
				MhvDownloadReport currObj = (MhvDownloadReport)it.next();
				if (latestObj.getCreatedTime().before(currObj.getCreatedTime()))
					latestObj = currObj;
			}
		}

		return latestObj;
	}

	public MhvDownloadReportServiceResponse getReportbyReportId(Long downloadReportId) {

		MhvDownloadReportServiceResponse response = new MhvDownloadReportServiceResponse();
		MhvDownloadReport downloadReport;
		List results = MhvDownloadReportBO.getReportbyReportId(downloadReportId);

		if (results != null && results.size() > 0 && !((MhvDownloadReportBO)results.get(0)).getAllMessages().hasErrorMessages()){
			downloadReport = ((MhvDownloadReportBO)results.get(0)).getMhvDownloadReportValues();
		} else {
			downloadReport = TransferObjectFactory.createMhvDownloadReport();
		}
		response.setMhvDownloadReport(downloadReport);

		return response;
	}

	public VoidServiceResponse generateDownload(Long userId) {
		LOG.info("Health Information Report is getting generated for: "+userId);
		PatientDataServiceDelegate patientDataServiceDelegate = getPatientDataServiceDelegate();
		patientDataServiceDelegate.generateDownload(userId.longValue());
		return null;
	}

	/*
	 * Generate selected data classes and date ranges (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.DownloadYourReportService#generateSelectedDownload(java.lang.Long, java.util.Collection, java.util.Date, java.util.Date)
	 */
	public VoidServiceResponse generateSelectedDownload(Long userId, Collection options, Date fromDate, Date endDate, Long dateSelection, Long typeSelection) {
		LOG.info("Selected Health Information Report is getting generated for: "+userId);
		PatientDataServiceDelegate patientDataServiceDelegate = getPatientDataServiceDelegate();
		patientDataServiceDelegate.generateDownload(userId.longValue(), options, fromDate, endDate, dateSelection.longValue(), typeSelection.longValue());
		return null;
	}

	private PatientDataServiceDelegate getPatientDataServiceDelegate() {
		return IntegrationServiceDelegateFactory.createPatientDataServiceDelegate();
	}

	public VoidServiceResponse updateLastAccess(Long downloadReportId) {
		List results = MhvDownloadReportBO.getReportbyReportId(downloadReportId);
		MhvDownloadReport downloadReport=null;
		if (results != null && results.size() > 0 && !((MhvDownloadReportBO)results.get(0)).getAllMessages().hasErrorMessages()){
			downloadReport = ((MhvDownloadReportBO)results.get(0)).getMhvDownloadReportValues();
		}
		if(downloadReport != null) {
			downloadReport.setLastAccess(new Timestamp(new Date().getTime()));
			MhvDownloadReportServiceResponse response = getEntityService().save(downloadReport);
		}
		else {
			LOG.error("CAN NOT UPDATE LAST ACCESS For the report id: " +downloadReportId);
		}
		return null;
	}
	public gov.va.med.mhv.usermgmt.service.EntityMaintenanceService getEntityService() {
		return gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService();
	}

	public BBPHRRefreshStatusServiceResponse getPHRRefreshStatus(Patient patient) {
		Precondition.assertNotNull("patient", patient);
		BBPHRRefreshStatusServiceResponse response = new BBPHRRefreshStatusServiceResponse();
        if (!isAnyExtractEnabled()) {
            if (LOG.isInfoEnabled()) {
            	LOG.info("Skipped isRefreshComplete for " + getUserName(patient)+
                	", because all extracts are disabled!");
            }
            //TODO: Need to add a message
            return response;
        }

//		PatientDataServiceDelegate pdsDelegate = IntegrationServiceDelegateFactory.createPatientDataServiceDelegate();
//        
//		PatientExtractStatus status = pdsDelegate.getStatus(new PatientIdentifier(patient.getIcn()));

        PhrConfigProperties phrProp = PhrConfigProperties.getInstance();
        PatientExtractStatus status = null;
    
        //Adding for New Phr Manager
        if( phrProp.isNewphr_enabled() && hasNewPhrAccess(patient.getUserProfile())) {
	        PhrManagerAdapter phrManager = new PhrManagerAdapter();
	        try {
	        	status = phrManager.getExtractStatus(null, patient);
			} catch (Exception e) {
				e.printStackTrace();
			}
        }
        else {
        	long s = System.currentTimeMillis();
        	PatientDataServiceDelegate pdsDelegate = IntegrationServiceDelegateFactory.createPatientDataServiceDelegate();
        	status = pdsDelegate.getStatus(new PatientIdentifier(patient.getIcn()));
	        if(LOG.isInfoEnabled()) {
	        	LOG.info("OLD Phr Extract took " + (System.currentTimeMillis() -s) +" ms for UserProfile: " +patient.getUserProfile().getId());
	        }
        }    
		
        BBPHRRefreshStatus refreshStatus = new BBPHRRefreshStatus();
        refreshStatus.setIsRefreshComplete(status.isCompleted());
        refreshStatus.setIsRefreshNeeded(status.needsRefresh());
        response.setBBPHRRefreshStatus(refreshStatus);

        if (LOG.isInfoEnabled()) {
        	LOG.info("Is Refresh needed? " + ": " + status.needsRefresh() +
            	":: Is Refresh completed? " + status.isCompleted() + " for the user: " + getUserName(patient));
        }

		return response;
	}




    private static boolean isAnyExtractEnabled() {
        List controls = ExtractControlBO.getEnabledExtracts();
        if (controls != null) {
            for(Object e: controls) {
                ExtractControlBO control = (ExtractControlBO) e;
                if ((control != null) &&
                		(control.getEnablementStatus() ==
                			ExtractEnablementStatusUtils.ENABLED  ||
                			control.getEnablementStatus() ==
                    			ExtractEnablementStatusUtils.PARTIAL))
                {
                    return true;
                }
            }
        }
        return false;
    }

	public VoidServiceResponse doRefresh(Patient patient) {
		Precondition.assertNotNull("patient", patient);
        if (!isAnyExtractEnabled()) {
            if (LOG.isInfoEnabled()) {
            	LOG.info("Skipped doRefresh for " + getUserName(patient)+
                	", because all extracts are disabled!");
            }
            return null;
        }
        RefreshDataParameters parameters = new RefreshDataParameters(
            new PatientIdentifier(patient.getIcn()));
        
        //Adding for NEW PHR....
        PhrConfigProperties phrProp = PhrConfigProperties.getInstance();
        if (phrProp.isNewphr_enabled() && hasNewPhrAccess(patient.getUserProfile()))  {
	        PhrManagerAdapter phrManager = new PhrManagerAdapter();
	        try {
				phrManager.refreshData(patient, null);
			} catch (Exception e) {
				e.printStackTrace();
			}
        }
        else {
        	long s = System.currentTimeMillis();
	        //getDelegate().refreshData(parameters);
        	getPatientDataServiceDelegate().refreshData(parameters);
	        if(LOG.isInfoEnabled()) {
	        	LOG.info("OLD Phr refreshData took " + (System.currentTimeMillis() -s) +" ms for UserProfile: " +patient.getUserProfile().getId());
	        }	
        }
//        getPatientDataServiceDelegate().refreshData(parameters);

        if (LOG.isDebugEnabled()) {
            LOG.debug("doRefresh(" + getUserName(patient));
        }

		return null;
	}

	private boolean hasNewPhrAccess(UserProfile userProfile)
	{
		boolean hasExtractAccess = false;
		AccessControlCollectionServiceResponse accessResponse =
			getAccessControlServiceDelegate().findAccessControls(userProfile.getUserName());
		//   Precondition.assertNotNull("response", response);
		hasExtractAccess = AccessControlUtils.hasAccess(AccessDomainUtils.NEWPHR,
				"NEWPHR",AccessPermissionUtils.READ, accessResponse.getAccessControls()); // "unchecked"
		return hasExtractAccess;
	}
	
	public AccessControlServiceDelegate getAccessControlServiceDelegate() {
		return ServiceDelegateFactory.createAccessControlServiceDelegate();
	}

    private String getUserName(Patient patient) {
        return ((patient != null) && (patient.getUserProfile() != null))
            ? "patient '" + patient.getUserProfile().getUserName() + "'"
            : "<unknown patient>";
    }

	public FacilityExtractStatusCollectionServiceResponse getExtractStatusList(Patient patient) {
		Precondition.assertNotNull("patient", patient);

		FacilityExtractStatusCollectionServiceResponse response = new FacilityExtractStatusCollectionServiceResponse();
        if (!isAnyExtractEnabled()) {
            if (LOG.isInfoEnabled()) {
            	LOG.info("Skipped getExtractStatusList for " + getUserName(patient)+
                	", because all extracts are disabled!");
            }
            return response;
        }

        PhrConfigProperties phrProp = PhrConfigProperties.getInstance();
        PatientExtractStatus status = null;
    
        //Adding for New Phr Manager
        if( phrProp.isNewphr_enabled() && hasNewPhrAccess(patient.getUserProfile())) {
	        PhrManagerAdapter phrManager = new PhrManagerAdapter();
	        try {
	        	status = phrManager.getExtractStatus(null, patient);
			} catch (Exception e) {
				e.printStackTrace();
			}
        }
        else {
        	long s = System.currentTimeMillis();
        	PatientDataServiceDelegate pdsDelegate = IntegrationServiceDelegateFactory.createPatientDataServiceDelegate();
        	status = pdsDelegate.getStatus(new PatientIdentifier(patient.getIcn()));
	        if(LOG.isInfoEnabled()) {
	        	LOG.info("OLD Phr Extract took " + (System.currentTimeMillis() -s) +" ms for UserProfile: " +patient.getUserProfile().getId());
	        }	
        }
        
//		PatientDataServiceDelegate pdsDelegate = IntegrationServiceDelegateFactory.createPatientDataServiceDelegate();
//        PatientExtractStatus status = pdsDelegate.getStatus(new PatientIdentifier(patient.getIcn()));
        
        Collection<gov.va.med.mhv.usermgmt.transfer.FacilityExtractStatus> extractList =
        					PhrInterfaceUtils.toFacilityExtractStatusses(patient, status);
		response.addItems(extractList);

        if (LOG.isInfoEnabled()) {
        	LOG.info("Size of Facility Extract list in getExtractStatusList(): " + extractList.size() + " for the user: " + getUserName(patient));
        }

		return response;
	}



}